﻿using System;
using System.Windows.Forms;

namespace StokYonetimSistemi.WinFormsUI
{
    public partial class frmAnasayfa : Form
    {
        public frmAnasayfa()
        {
            InitializeComponent();
        }

        // --- YÖNETİM MENÜSÜ ---

        private void kategoriYönetimiToolStripMenuItem_Click(object sender, EventArgs e)
        {
            frmKategoriYonetimi form = new frmKategoriYonetimi();
            form.ShowDialog(); // Formu modal olarak açar, yani bu form kapanmadan arkadakine geçilemez.
        }

        private void ürünYönetimiToolStripMenuItem_Click(object sender, EventArgs e)
        {
            frmUrunYonetimi form = new frmUrunYonetimi();
            form.ShowDialog();
        }

        // --- STOK İŞLEMLERİ MENÜSÜ ---

        private void stokGirisToolStripMenuItem_Click(object sender, EventArgs e)
        {
            frmStokGiris form = new frmStokGiris();
            form.ShowDialog();
        }

        private void stokÇıkışToolStripMenuItem_Click(object sender, EventArgs e)
        {
            frmStokCikis form = new frmStokCikis();
            form.ShowDialog();
        }

        // --- DOSYA MENÜSÜ ---

        private void çıkışToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // Kullanıcıya onay sorusu sorarak daha profesyonel bir çıkış yapalım.
            var sonuc = MessageBox.Show("Uygulamadan çıkmak istediğinize emin misiniz?", "Çıkış Onayı",
                                        MessageBoxButtons.YesNo, MessageBoxIcon.Question);
            if (sonuc == DialogResult.Yes)
            {
                Application.Exit();
            }
        }

        // --- FORM KAPATMA OLAYI ---

        // Bu metot, formun sağ üstteki 'X' butonuna basıldığında tetiklenir.
        // Login formu sadece gizlendiği için, ana form kapanınca uygulamanın tamamen sonlanmasını sağlar.
        private void frmAnasayfa_FormClosed(object sender, FormClosedEventArgs e)
        {
            Application.Exit();
        }
    }
}